
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  spi.h: SD/MMC card SPI communication functions
  Written by Mauro Grassi and updated by Nicholas Vinen, 2009-2013
*/

#ifndef SPI_H
#define SPI_H

#include <xc.h>
#include "GenericTypeDefs.h"

//on pin 4, RB0
#define SDCS			(LATBbits.LATB0)
#define SDCS_TRIS		(TRISBbits.TRISB0)

void 					DeinitSPI();
void 					InitSPI(int speed);
unsigned int 			WriteSPI(unsigned int x);
unsigned int 			WriteSPIWithoutSS(unsigned int x);
void					BulkReadSPI(BYTE* data);
void                    BulkReadSPIInto(unsigned char* buf);

#endif
